/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateSweep.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFeature.h"
#include "CApplication.h"


//	Sweeps profileSketch on pathSketch with the specified  
//	material status and return the newly created sweep.

HRESULT CreateSweep(ISketch *profileSketch, ISketch *pathSketch, long materialStatus, CString sweepName, ISweep **pSweep)
{

	START_METHOD("CreateSweep")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	ISweep *sweep = NULL;
	status = (GetCLASS(Sweep))->CreateSweep(pDesign, profileSketch, pathSketch, 0, materialStatus, 0, &sweep);
	CHECK_RETURN_STATUS(status)

	IOperation *operation = CAST(IOperation, sweep);
	status = operation->SetName(sweepName.AllocSysString());
	CHECK_RETURN_STATUS(status)
	*pSweep = sweep;

	END_METHOD("CreateSweep")
}
